/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.compat.jei;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ChiselingRecipeCategory
implements IRecipeCategory<ChiselingRecipe> {
    private final IDrawable backgrounds;
    private final IDrawable icon;

    public ChiselingRecipeCategory(IGuiHelper guiHelper) {
        this.backgrounds = guiHelper.createDrawable(new ResourceLocation("rechiseled", "textures/screen/jei_category_background.png"), 0, 0, 174, 72);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)Rechiseled.chisel));
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("rechiseled", "chiseling");
    }

    public Class<? extends ChiselingRecipe> getRecipeClass() {
        return ChiselingRecipe.class;
    }

    public Component getTitle() {
        return TextComponents.translation((String)"rechiseled.jei_category.title").get();
    }

    public IDrawable getBackground() {
        return this.backgrounds;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ChiselingRecipe recipe, IIngredients ingredients) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList outputs = new ArrayList();
        for (ChiselingEntry entry : recipe.getEntries()) {
            ArrayList<ItemStack> output = new ArrayList<ItemStack>();
            if (entry.hasRegularItem()) {
                inputs.add(new ItemStack((ItemLike)entry.getRegularItem()));
                output.add(new ItemStack((ItemLike)entry.getRegularItem()));
            }
            if (entry.hasConnectingItem()) {
                inputs.add(new ItemStack((ItemLike)entry.getConnectingItem()));
                output.add(new ItemStack((ItemLike)entry.getConnectingItem()));
            }
            outputs.add(output);
        }
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(inputs));
        ingredients.setOutputLists(VanillaTypes.ITEM, outputs);
    }

    public void setRecipe(IRecipeLayout recipeLayout, ChiselingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 27);
        guiItemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        for (int i = 0; i < outputs.size(); ++i) {
            int x = 48 + 18 * (i % 7);
            int y = 18 * (i / 7);
            guiItemStacks.init(i + 1, false, x, y);
            guiItemStacks.set(i + 1, (List)outputs.get(i));
        }
    }
}

